<?php
extract ( shortcode_atts ( array (
	'style' => 'sm-style-boxed',
	'value' => '',
	'color' => '',
	'text' => '',
	'prefix' => '',
	'suffix' => '',
	'align' => '',
	'number_font_size' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '', 
), $atts ) );

$id = sm_shortcode_unique_id( 'sm_counterbox' );
$css_gen = new Inline_CSS_Generator( "sm-counterbox", $id );
$css_class = array( 'sm-counterbox', 'sm_content_element' );

$style = sm_validate_with_array( $style, sm_get_counterbox_styles_array() );
$css_class[] = $style;

$icon = sm_get_icon_from_atts( $atts );

$scoped_css = '';
if ( !empty( $color ) ) {
	if ( 'sm-style-boxed' == $style ) {
		$scoped_css .= $css_gen->css( '.counterbox-container', 
			array( 'border-color' => $color, 'color' => $color ) );
	} else {
		$scoped_css .= $css_gen->css( array( '.counter-value', '.cb-text', '.icon-wrap' ), array( 'color' => $color ) );
	}
}
if ( 'sm-style-flip' == $style ) {
	if ( !empty( $color ) ) {
		$scoped_css .= $css_gen->css( '.flip:nth-last-child(3n+4):after', 
			array( 'color' => $color, 'color' => $color ) );
	}
}
$align = sm_validate_with_array( $align, sm_get_default_aligns_array() );
if ( !empty( $align ) ) {
	$css_class[] = $align;
}

if ( !empty( $number_font_size ) ) {
	$scoped_css .= $css_gen->css( array( '.counter-value' ), array( 'font-size' => $number_font_size ) );
}

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
$wrapper_attributes[] = 'data-value="' . esc_attr( $value ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php sm_the_scoped_css( $scoped_css ); ?>
<?php if ( 'sm-style-flip' == $style ) : ?>
	<?php
	wp_enqueue_script( 'flipclock' );
	wp_enqueue_style( 'flipclock' );
	?>
	<div class="sm-flip-wrap">
		<div class="sm-flip-counter" data-value="<?php echo esc_attr( $value ); ?>"></div>
		<div class="cb-text"><?php echo esc_html( $text ); ?></div>
	</div>
<?php elseif ( 'sm-style-number' == $style ) : ?>
	<div class="counter-value"><?php echo esc_html( $prefix ); ?><span class="numeric-value"><?php echo esc_html( $value ); ?></span><?php echo esc_html( $suffix ); ?></div>
<?php else : ?>
	<div class="counterbox-container">
		<div class="counterbox-inner">
			<div class="icon-wrap"><div class="icon-wrap-inner"><i class="<?php echo esc_attr( $icon ); ?>"></i></div></div>
			<div class="info-wrap">
			<?php if ( 'sm-style-split' == $style ): ?>
				<div class="cb-text"><?php echo esc_html( $text ); ?></div>
				<div class="counter-value"><?php echo esc_html( $prefix ); ?><span class="numeric-value"><?php echo esc_html( $value ); ?></span><?php echo esc_html( $suffix ); ?></div>
			<?php else : ?>
				<div class="counter-value"><?php echo esc_html( $prefix ); ?><span class="numeric-value"><?php echo esc_html( $value ); ?></span><?php echo esc_html( $suffix ); ?></div>
				<div class="cb-text"><?php echo esc_html( $text ); ?></div>
			<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>
</div>
